
#ifndef _DPP_TLB_REG_H_
#define _DPP_TLB_REG_H_

#include "zxic_common.h"
#include "dpp_type_api.h"
#include "dpp_reg_struct.h"

#ifdef __cplusplus
extern "C" {
#endif

#define  TLB_VA_WIDTH_MAX       (ZXIC_UINT32)(64)
#define  TLB_PA_WIDTH_MAX       (ZXIC_UINT32)(128)
#define  TLB_CFG_REG_STEP       (ZXIC_UINT32)(0x20)
#define  TLB_REG_DATA_MAX       (ZXIC_UINT32)(128)
#define  TLB_VA_WIDTH           (ZXIC_UINT32)(36)
#define  TLB_PA_WIDTH           (ZXIC_UINT32)(84)

#define  TLBi_31_0      (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000000)
#define  TLBi_63_32     (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000004)
#define  TLBi_95_64     (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000008)
#define  TLBi_127_96    (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x0000000c)
#define  TLBi_159_128   (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000010)
#define  TLBi_191_160   (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000014)
#define  TLBi_223_192   (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000018)
#define  TLBi_255_224   (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x0000001c)

#define TLB_CONFIG_REG              (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000000)
#define TLB_DSP0_OUPUT_ADDRESS_RD   (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000004)
#define TLB_DSP0_OUPUT_ADDRESS_RW   (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000008)
#define TLB_DSP0_RW_ERR             (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000010)
#define TLB_DSP0_RW_ERR_ADDR        (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000014)
#define TLB_DSP0_RW_ERR_ADDR_HIGH   (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000018)
#define TLB_DSP0_RD_ERR             (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x0000001C)
#define TLB_DSP0_RD_ERR_ADDR        (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000020)
#define TLB_DSP0_RD_ERR_ADDR_HIGH   (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000024)
#define TLB_O_DSP0_INT_CLR          (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000028)

#define TLB_INT_ENABLE_IN           (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x0000006C)
#define TLB_INT_CLR_IN              (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000070)
#define TLB_INT_SET_IN              (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000074)
#define TLB_INT_STAT_OUT            (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000078)
#define TLB_VA_PA_VA_SWITCH_FLAG    (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x0000007C)
#define TLB_WRITE_ERR_IND           (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000080)
#define TLB_READ_ERR_AID            (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000084)

/*PA_VA SWIT0*/
#define TLB_PA_VA_SWIT0_IN        (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x0000002C)  /**<  @brief PA_WIDTH<=40 物理地址[PA_WIDTH-1:12];PA_WIDTH>40 PA_WIDTH 物理地址[39:12]*/
#define TLB_PA_VA_SWIT0_IN_H0     (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000030)  /**<  @brief PA_WIDTH(40,64] 物理地址[PA_WIDTH-1:64];PA_WIDTH>64 PA_WIDTH 物理地址[63:40]*/
#define TLB_PA_VA_SWIT0_IN_H1     (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000088)  /**<  @brief PA_WIDTH(64,96] 物理地址[PA_WIDTH-1:96];PA_WIDTH>96 物理地址[95:64]*/
#define TLB_PA_VA_SWIT0_IN_H2     (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x0000008C)  /**<  @brief PA_WIDTH>96 物理地址[PA_WIDTH-1:96]*/

#define TLB_PA_VA_SWIT0_OUT       (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000034)  /**<  @brief 只读 VA_WIDTH<=40 虚拟地址[PA_WIDTH-1:12];VA_WIDTH>40 虚拟地址[39:12]*/
#define TLB_PA_VA_SWIT0_OUT_H     (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000038)  /**<  @brief 只读 VA_WIDTH>40 虚拟地址[PA_WIDTH-1:40]*/

#define TLB_VA_PA_SWIT0_IN        (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x0000003C)  /**<  @brief VA_WIDTH<=40 虚拟地址[VA_WIDTH-1:12];VA_WIDTH>40 VA_WIDTH 虚拟地址[39:12]*/
#define TLB_VA_PA_SWIT0_IN_H      (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000040)  /**<  @brief VA_WIDTH>40 虚拟地址[VA_WIDTH-1:40]*/

#define TLB_VA_PA_SWIT0_OUT       (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000044)  /**<  @brief 只读 PA_WIDTH<=40 物理地址[PA_WIDTH-1:12];PA_WIDTH>40 PA_WIDTH 物理地址[39:12]*/
#define TLB_VA_PA_SWIT0_OUT_H0    (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000048)  /**<  @brief 只读 PA_WIDTH(40,64] 物理地址[PA_WIDTH-1:64];PA_WIDTH>64 PA_WIDTH 物理地址[63:40]*/
#define TLB_VA_PA_SWIT0_OUT_H1    (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000090)  /**<  @brief 只读 PA_WIDTH(64,96] 物理地址[PA_WIDTH-1:96];PA_WIDTH>96 物理地址[95:64]*/
#define TLB_VA_PA_SWIT0_OUT_H2    (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000094)  /**<  @brief 只读 PA_WIDTH>96 物理地址[PA_WIDTH-1:96]*/

/*PA_VA SWIT1*/
#define TLB_PA_VA_SWIT1_IN        (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x0000004C)
#define TLB_PA_VA_SWIT1_IN_H0     (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000050)
#define TLB_PA_VA_SWIT1_IN_H1     (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000098)
#define TLB_PA_VA_SWIT1_IN_H2     (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x0000009C)

#define TLB_PA_VA_SWIT1_OUT       (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000054)
#define TLB_PA_VA_SWIT1_OUT_H     (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000058)

#define TLB_VA_PA_SWIT1_IN        (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x0000005C)
#define TLB_VA_PA_SWIT1_IN_H      (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000060)

#define TLB_VA_PA_SWIT1_OUT       (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000064)
#define TLB_VA_PA_SWIT1_OUT_H0    (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000068)
#define TLB_VA_PA_SWIT1_OUT_H1    (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x000000A0)
#define TLB_VA_PA_SWIT1_OUT_H2    (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x000000A4)


#define TLB_INT_ENABLE_IN         (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x0000006C)
#define TLB_INT_CLR_IN            (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000070)
#define TLB_INT_SET_IN            (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000074)
#define TLB_INT_STAT_OUT          (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000078)
#define TLB_VA_PA_VA_SWITCH_FLAG  (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x0000007C)
#define TLB_WRITE_ERR_AID         (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000080)
#define TLB_READ_ERR_AID          (ZXIC_UINT32)(SYS_TLB_BASE_ADDR + 0x00000084)

typedef enum dpp_tlb_reg_info_e
{
    TLBi_31_0_REGr  		      = 0,
    TLBi_63_32_REGr 		      = 1,
	TLBi_95_64_REGr 	          = 2,
	TLBi_127_96_REGr              = 3,
    TLBi_159_128_REGr 	          = 4,
    TLBi_191_160_REGr 	          = 5,
    TLBi_223_192_REGr 	          = 6,
	TLBi_255_224_REGr             = 7,

    TLB_CONFIG_REGr               = 8,

    TLB_PA_VA_SWIT0_IN_REGr       = 9,     /**<  @brief PA_WIDTH<=40,物理基地址[PA_WIDTH-1:12];PA_WIDTH>40,物理基地址[39:12]*/
    TLB_PA_VA_SWIT0_IN_H0_REGr    = 10,    /**<  @brief PA_WIDTH<=64,物理基地址[PA_WIDTH-1:40];PA_WIDTH>64,物理基地址[63:40]*/
    TLB_PA_VA_SWIT0_IN_H1_REGr    = 11,    /**<  @brief PA_WIDTH<=96,物理基地址[PA_WIDTH-1:64];PA_WIDTH>64,物理基地址[95:64]*/
    TLB_PA_VA_SWIT0_IN_H2_REGr    = 12,    /**<  @brief PA_WIDTH>96,物理基地址[PA_WIDTH-1:96]*/
    TLB_PA_VA_SWIT1_IN_REGr       = 13,
    TLB_PA_VA_SWIT1_IN_H0_REGr    = 14,
    TLB_PA_VA_SWIT1_IN_H1_REGr    = 15,
    TLB_PA_VA_SWIT1_IN_H2_REGr    = 16,

    TLB_PA_VA_SWIT0_OUT_REGr      = 17,    /**<  @brief 只读 VA_WIDTH<=40,虚拟基地址[VA_WIDTH-1:12];VA_WIDTH>40,虚拟基地址[39:12]*/
    TLB_PA_VA_SWIT0_OUT_H_REGr    = 18,    /**<  @brief 只读 VA_WIDTH>40,虚拟基地址[VA_WIDTH-1:40]*/
    TLB_PA_VA_SWIT1_OUT_REGr      = 19,
    TLB_PA_VA_SWIT1_OUT_H_REGr    = 20,

    TLB_VA_PA_SWIT0_IN_REGr       = 21,   /**<  @brief VA_WIDTH<=40,虚拟基地址[VA_WIDTH-1:12];VA_WIDTH>40,虚拟基地址[39:12]*/
    TLB_VA_PA_SWIT0_IN_H_REGr     = 22,   /**<  @brief VA_WIDTH>40,虚拟基地址[VA_WIDTH-1:40]*/
    TLB_VA_PA_SWIT1_IN_REGr       = 23,
    TLB_VA_PA_SWIT1_IN_H_REGr     = 24,

    TLB_VA_PA_SWIT0_OUT_REGr      = 25,   /**<  @brief 只读 PA_WIDTH<=40,物理基地址[PA_WIDTH-1:12];PA_WIDTH>40,物理基地址[39:12]*/
    TLB_VA_PA_SWIT0_OUT_H0_REGr   = 26,   /**<  @brief 只读 PA_WIDTH<=64,物理基地址[PA_WIDTH-1:40];PA_WIDTH>64,物理基地址[63:40]*/
    TLB_VA_PA_SWIT0_OUT_H1_REGr   = 27,   /**<  @brief 只读 PA_WIDTH<=96,物理基地址[PA_WIDTH-1:64];PA_WIDTH>64,物理基地址[95:64]*/
    TLB_VA_PA_SWIT0_OUT_H2_REGr   = 28,   /**<  @brief 只读 PA_WIDTH>96,物理基地址[PA_WIDTH-1:96]*/
    TLB_VA_PA_SWIT1_OUT_REGr      = 29,
    TLB_VA_PA_SWIT1_OUT_H0_REGr   = 30,
    TLB_VA_PA_SWIT1_OUT_H1_REGr   = 31,
    TLB_VA_PA_SWIT1_OUT_H2_REGr   = 32,

    TLB_DSP0_OUTPUT_ADDRESS_RD_REGr = 33,   /**<  @brief RW 读错误发生后，继续工作模式下配置为输出固定地址时，输出此固定地址，若输出固定地址，则高位自动补0*/
    TLB_DSP0_OUTPUT_ADDRESS_RW_REGr = 34,   /**<  @brief RW 写错误发生后，继续工作模式下配置为输出固定地址时，输出此固定地址，若输出固定地址，则高位自动补0*/

    TLB_DSP0_RW_ERR_REGr            = 35,   /**<  @brief 只读 写地址错误类型(b0000:no error b0010:write err b0100:miss hit b1000:multi hit)*/
                                            /**<  @brief 只读 写地址错误状态(b1:error b0:no error)，锁存首次错误状态*/
    TLB_DSP0_RW_ERR_ADDR_REGr       = 36,   /**<  @brief 只读 写地址错误地址，锁存首次错误地址*/
    TLB_DSP0_RW_ERR_ADDR_HIGH_REGr  = 37,   /**<  @brief 只读 写地址错误地址高位，锁存首次错误地址高位，当VA_WIDTH=32时保留，VA_WIDTH>32位时有效*/

    TLB_DSP0_RD_ERR_REGr            = 38,   /**<  @brief 只读 读地址错误类型(b0000:no error b0010:write err b0100:miss hit b1000:multi hit)*/
                                            /**<  @brief 只读 读地址错误状态(b1:error b0:no error)，锁存首次错误状态*/
    TLB_DSP0_RD_ERR_ADDR_REGr       = 39,   /**<  @brief 只读 读地址错误地址，锁存首次错误地址*/
    TLB_DSP0_RD_ERR_ADDR_HIGH_REGr  = 40,   /**<  @brief 只读 读地址错误地址高位，锁存首次错误地址高位，当VA_WIDTH=32时保留，VA_WIDTH>32位时有效*/

    TLB_O_DSP0_INT_CLR_REGr         = 41,   /**<  @brief 只写 清除寄存器，用APB总线直接进行写，写1表示清除，可清除电平中断*/

    TLB_INT_ENABLE_IN_REGr          = 42,   /**<  @brief 读写 掩码输入信号，0：屏蔽 1：不屏蔽 默认不屏蔽*/
    TLB_INT_CLR_IN_REGr             = 43,   /**<  @brief 只写 清除状态输入信号，软件配置写1表示清除*/
    TLB_INT_SET_IN_REGr             = 44,   /**<  @brief 只写 中断注入选择输入，写1表示软件模拟外部产生中断*/
    TLB_INT_STA_OUT_REGr            = 45,   /**<  @brief 只写 中断状态输出信号，读出1表示此位有中断输出*/

    TLB_VA_PA_VA_SWITCH_FLAG_REGr   = 46,   /**<  @brief 只读 TLB写/读的VA_PA标志，1表示VA_PA_SWITO_IN/VA_PA_SWIT1_IN完成*/
                                            /**<  @brief 只读 TLB写/读的PA_VA标志,1表示PA_VA_SWITO_IN/PA_VA_SWIT1_IN完成*/
    TLB_WRITE_ERR_AID_REGr          = 47,   /**<  @brief 只读 写地址错误的ID，锁存首次错误ID*/
    TLB_READ_ERR_AID_REGr           = 48,   /**<  @brief 只读 读地址错误的ID，锁存首次错误ID*/

    TLB_REGr_BUTT
}DPP_TLB_REG_INFO_E;

typedef struct dpp_tlbi_31_0_t
{
    ZXIC_UINT32 mask_l;
    ZXIC_UINT32 rd_valid;
    ZXIC_UINT32 wr_valid;
    ZXIC_UINT32 valid;
}DPP_TLBi_31_0_T;

typedef struct dpp_tlbi_63_32_t
{
    ZXIC_UINT32 mask_h;
}DPP_TLBi_63_32_T;

typedef struct dpp_tlbi_95_64_t
{
    ZXIC_UINT32 va_l;
}DPP_TLBi_95_64_T;

typedef struct dpp_tlbi_127_96_t
{
    ZXIC_UINT32 va_h;
}DPP_TLBi_127_96_T;

typedef struct dpp_tlbi_159_128_t
{
    ZXIC_UINT32 pa_l;
}DPP_TLBi_159_128_T;

typedef struct dpp_tlbi_191_160_t
{
    ZXIC_UINT32 pa_h0;
}DPP_TLBi_191_160_T;

typedef struct dpp_tlbi_223_192_t
{
    ZXIC_UINT32 pa_h1;
}DPP_TLBi_223_192_T;

typedef struct dpp_tlbi_255_224_t
{
    ZXIC_UINT32 pa_h2;
}DPP_TLBi_255_224_T;

typedef struct dpp_tlb_global_cfg_t
{
    ZXIC_UINT32 regslice_en;   /*是否使用寄存器片打拍*/
    ZXIC_UINT32 output_sel;    /*配置继续工作模式下出错后输出透传地址还是固定地址 1：输出透传地址 0：输出固定地址，默认输出透传地址*/
    ZXIC_UINT32 tlb_en;        /*TLB模块使能 1：使能 0：不使能*/
    ZXIC_UINT32 int_mode;      /*中断模式 1：高脉冲，固定为高脉冲，软件不可配*/
    ZXIC_UINT32 int_en;        /*中断使能 1：中断打开 0：中断关闭*/
    ZXIC_UINT32 op_con_open;   /*配置发生错误后是否继续工作模式，1：继续工作，固定为继续工作模式，软件不可配*/
    ZXIC_UINT32 map_enable;    /*地址映射模式 1：地址映射 2：地址透传*/
}DPP_TLB_GLOBAL_CFG_T;

typedef struct dpp_tlb_dsp0_output_addr_rd_t
{
    ZXIC_UINT32 output_addr_rd;   /*读错误发生后，继续工作模式下配置为输出固定地址时，输出此固定地址*/
}DPP_TLB_DSP0_OUTPUT_ADDR_RD_T;

typedef struct dpp_tlb_dsp0_output_addr_rw_t
{
    ZXIC_UINT32 output_addr_rw;   /*写错误发生后，继续工作模式下配置为输出固定地址时，输出此固定地址*/
}DPP_TLB_DSP0_OUTPUT_ADDR_RW_T;

typedef struct dpp_tlb_dsp0_rw_err_t
{
    ZXIC_UINT32 rw_err_status;   /*写地址错误状态 1：error 0：no error，锁存首次错误状态*/
    ZXIC_UINT32 rw_err_type;     /*写地址错误类型 b0000:no error b0020:write err b0100:miss hit b1000:multi hit*/
}DPP_TLB_DSP0_RW_ERR_T;

typedef struct dpp_tlb_dsp0_rw_err_addr_t
{
    ZXIC_UINT32 rw_err_addr;   /*写地址错误地址*/
}DPP_TLB_DSP0_RW_ERR_ADDR_T;

typedef struct dpp_tlb_dsp0_rw_err_addr_high_t
{
    ZXIC_UINT32 rw_err_addr_high;   /*写地址错误地址高位*/
}DPP_TLB_DSP0_RW_ERR_ADDR_HIGH_T;

typedef struct dpp_tlb_dsp0_rd_err_t
{
    ZXIC_UINT32 rd_err_status;   /*读地址错误状态 1：error 0：no error，锁存首次错误状态*/
    ZXIC_UINT32 rd_err_type;     /*读地址错误类型 b0000:no error b0020:write err b0100:miss hit b1000:multi hit*/
}DPP_TLB_DSP0_RD_ERR_T;

typedef struct dpp_tlb_dsp0_rd_err_addr_t
{
    ZXIC_UINT32 rd_err_addr;   /*读地址错误地址*/
}DPP_TLB_DSP0_RD_ERR_ADDR_T;

typedef struct dpp_tlb_dsp0_rd_err_addr_high_t
{
    ZXIC_UINT32 rd_err_addr_high;   /*读地址错误地址高位*/
}DPP_TLB_DSP0_RD_ERR_ADDR_HIGH_T;
typedef struct dpp_tlb_o_dsp0_int_clr_t
{
    ZXIC_UINT32 dsp0_int_clr;   /*清除寄存器，用APB总线直接进行写，写1表示清除*/
}DPP_TLB_O_DSP0_INT_CLR_T;

typedef struct dpp_tlb_int_enable_in_t
{
    ZXIC_UINT32 int_enable_in;   /*掩码输入信号，0为屏蔽，1为不屏蔽，默认不屏蔽*/
}DPP_TLB_INT_ENABLE_IN_T;

typedef struct dpp_tlb_int_clr_in_t
{
    ZXIC_UINT32 int_clr_in;   /*清除状态输入信号，软件配置写1表示清除*/
}DPP_TLB_INT_CLR_IN_T;

typedef struct dpp_tlb_int_set_in_t
{
    ZXIC_UINT32 int_set_in;   /*中断注入选择输入，写1表示软件模拟外部产生中断*/
}DPP_TLB_INT_SET_IN_T;

typedef struct dpp_tlb_int_sta_out_t
{
    ZXIC_UINT32 int_sta_out;   /*中断状态输出信号，读出1表示此位有中断输出*/
}DPP_TLB_INT_STA_OUT_T;

typedef struct dpp_tlb_va_pa_va_swit_flag_t
{
    ZXIC_UINT32 pa_va_swit1_flag;   /*TLB读的PA VA转换标志，1表示寄存器PA_PA_SWIT1_IN写完成*/
    ZXIC_UINT32 pa_va_swit0_flag;   /*TLB写的PA VA转换标志，1表示寄存器PA_PA_SWIT0_IN写完成*/
    ZXIC_UINT32 va_pa_swit1_flag;   /*TLB读的VA PA转换标志，1表示寄存器VA_PA_SWIT1_IN写完成*/
    ZXIC_UINT32 va_pa_swit0_flag;   /*TLB写的VA PA转换标志，1表示寄存器VA_PA_SWIT0_IN写完成*/
}DPP_TLB_VA_PA_VA_SWIT_FLAG_T;

typedef struct dpp_tlb_write_err_aid_t
{
    ZXIC_UINT32 wr_err_aid;   /*写地址错误的id*/
}DPP_TLB_WRITE_ERR_AID_T;

typedef struct dpp_tlb_read_err_aid_t
{
    ZXIC_UINT32 rd_err_aid;   /*读地址错误的id*/
}DPP_TLB_READ_ERR_AID_T;

typedef struct dpp_tlb_pa_va_swit0_in_t
{
    ZXIC_UINT32 pa_va_swit0_in;
}DPP_TLB_PA_VA_SWIT0_IN_T;

typedef struct dpp_tlb_pa_va_swit0_in_h0_t
{
    ZXIC_UINT32 pa_va_swit0_in_h0;
}DPP_TLB_PA_VA_SWIT0_IN_H0_T;

typedef struct dpp_tlb_pa_va_swit0_in_h1_t
{
    ZXIC_UINT32 pa_va_swit0_in_h1;
}DPP_TLB_PA_VA_SWIT0_IN_H1_T;

typedef struct dpp_tlb_pa_va_swit0_in_h2_t
{
    ZXIC_UINT32 pa_va_swit0_in_h2;
}DPP_TLB_PA_VA_SWIT0_IN_H2_T;

typedef struct dpp_tlb_pa_va_swit1_in_t
{
    ZXIC_UINT32 pa_va_swit1_in;
}DPP_TLB_PA_VA_SWIT1_IN_T;

typedef struct dpp_tlb_pa_va_swit1_in_h0_t
{
    ZXIC_UINT32 pa_va_swit1_in_h0;
}DPP_TLB_PA_VA_SWIT1_IN_H0_T;

typedef struct dpp_tlb_pa_va_swit1_in_h1_t
{
    ZXIC_UINT32 pa_va_swit1_in_h1;
}DPP_TLB_PA_VA_SWIT1_IN_H1_T;

typedef struct dpp_tlb_pa_va_swit1_in_h2_t
{
    ZXIC_UINT32 pa_va_swit1_in_h2;
}DPP_TLB_PA_VA_SWIT1_IN_H2_T;

typedef struct dpp_tlb_pa_va_swit0_out_t
{
    ZXIC_UINT32 pa_va_swit0_out;
}DPP_TLB_PA_VA_SWIT0_OUT_T;

typedef struct dpp_tlb_pa_va_swit0_out_h_t
{
    ZXIC_UINT32 pa_va_swit0_out_h;
}DPP_TLB_PA_VA_SWIT0_OUT_H_T;

typedef struct dpp_tlb_pa_va_swit1_out_t
{
    ZXIC_UINT32 pa_va_swit1_out;
}DPP_TLB_PA_VA_SWIT1_OUT_T;

typedef struct dpp_tlb_pa_va_swit1_out_h_t
{
    ZXIC_UINT32 pa_va_swit1_out_h;
}DPP_TLB_PA_VA_SWIT1_OUT_H_T;

typedef struct dpp_tlb_va_pa_swit0_in_t
{
    ZXIC_UINT32 va_pa_swit0_in;
}DPP_TLB_VA_PA_SWIT0_IN_T;

typedef struct dpp_tlb_va_pa_swit0_in_h_t
{
    ZXIC_UINT32 va_pa_swit0_in_h;
}DPP_TLB_VA_PA_SWIT0_IN_H_T;

typedef struct dpp_tlb_va_pa_swit1_in_t
{
    ZXIC_UINT32 va_pa_swit1_in;
}DPP_TLB_VA_PA_SWIT1_IN_T;

typedef struct dpp_tlb_va_pa_swit1_in_h_t
{
    ZXIC_UINT32 va_pa_swit1_in_h;
}DPP_TLB_VA_PA_SWIT1_IN_H_T;

typedef struct dpp_tlb_va_pa_swit0_out_t
{
    ZXIC_UINT32 va_pa_swit0_out;
}DPP_TLB_VA_PA_SWIT0_OUT_T;

typedef struct dpp_tlb_va_pa_swit0_out_h0_t
{
    ZXIC_UINT32 va_pa_swit0_out_h0;
}DPP_TLB_VA_PA_SWIT0_OUT_H0_T;

typedef struct dpp_tlb_va_pa_swit0_out_h1_t
{
    ZXIC_UINT32 va_pa_swit0_out_h1;
}DPP_TLB_VA_PA_SWIT0_OUT_H1_T;

typedef struct dpp_tlb_va_pa_swit0_out_h2_t
{
    ZXIC_UINT32 va_pa_swit0_out_h2;
}DPP_TLB_VA_PA_SWIT0_OUT_H2_T;

typedef struct dpp_tlb_va_pa_swit1_out_t
{
    ZXIC_UINT32 va_pa_swit1_out;
}DPP_TLB_VA_PA_SWIT1_OUT_T;

typedef struct dpp_tlb_va_pa_swit1_out_h0_t
{
    ZXIC_UINT32 va_pa_swit1_out_h0;
}DPP_TLB_VA_PA_SWIT1_OUT_H0_T;

typedef struct dpp_tlb_va_pa_swit1_out_h1_t
{
    ZXIC_UINT32 va_pa_swit1_out_h1;
}DPP_TLB_VA_PA_SWIT1_OUT_H1_T;

typedef struct dpp_tlb_va_pa_swit1_out_h2_t
{
    ZXIC_UINT32 va_pa_swit1_out_h2;
}DPP_TLB_VA_PA_SWIT1_OUT_H2_T;

/***********************************************************/
/** 获取 TLB 寄存器属性信息
* @param   reg_type  TLB寄存器类型
*
* @return  
* @remark  无
* @see
* @author  cbb      @date  2022/09/02
************************************************************/
DPP_REG_T *dpp_tlb_info_get(ZXIC_UINT32 reg_type);

/** tlb寄存器数据写入
* @param   dev_id    设备号
* @param   reg_type  寄存器类型
* @param   entry_id  entry寄存器0~(entry_num-1),全局寄存器entry_num
* @param   pdata     寄存器数据
* @return
* @remark  无
* @see
* @author  chenqin00181032      @date  2023/04/20
************************************************************/
DPP_STATUS dpp_tlb_write(ZXIC_UINT32 dev_id, 
                                   DPP_TLB_REG_INFO_E reg_type,
                                   ZXIC_UINT32 entry_id, 
                                   ZXIC_VOID *p_data
                                   );

/** 读取tlb寄存器数据
* @param   dev_id    设备号
* @param   reg_type  寄存器类型
* @param   entry_id  entry寄存器0~(entry_num-1),全局寄存器entry_num
* @param   pdata     寄存器数据
* @return
* @remark  无
* @see
* @author  chenqin00181032      @date  2023/04/20
************************************************************/
DPP_STATUS dpp_tlb_read(ZXIC_UINT32 dev_id, 
                                   DPP_TLB_REG_INFO_E reg_type,
                                   ZXIC_UINT32 entry_id, 
                                   ZXIC_VOID *p_data
                                   );

#ifdef __cplusplus
}
#endif

#endif