/**************************************************************
* 版权所有 (C)2015-2020, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_stump.h
* 文件标识 :
* 内容摘要 :
* 其它说明 :
* 当前版本 :
* 作    者 : wcl
* 完成日期 : 2018/11/01
* DEPARTMENT: ASIC_FPGA_R&D_Dept
* MANUAL_PERCENT: 100%

* 修改记录1:
* 修改日期:
* 版 本 号:
* 修 改 人:
* 修改内容:
***************************************************************/

#ifndef _DPP_STUMP_H_
#define _DPP_STUMP_H_

#ifdef __cplusplus
extern "C" {
#endif

#define DPP_STUMP_REG_NO_INVALID         (0xffffffff)
#define DPP_STUMP_TM_INDRECT_ADDR        (0xf0000000)
#define DPP_STUMP_TM_INDRECT_ADDR_H      (0xf8000000)

/** RAM打桩唯一标识，包括:直接寄存器间接访问和间接寄存器间接访问 */
typedef enum dpp_stump_ram_id_e
{
    DPP_STUMPRAM_DDR = 0,
    DPP_STUMPRAM_CAR_A_QUEUE = 1,
    DPP_STUMPRAM_CAR_B_QUEUE = 2,
    DPP_STUMPRAM_CAR_C_QUEUE = 3,
    DPP_STUMPRAM_CAR_A_PROFILE = 4,
    DPP_STUMPRAM_ZCAM = 5,
    DPP_STUMPRAM_ERAM = 6,
    DPP_STUMPRAM_ETCAM = 7,
    DPP_STUMPRAM_PHYPORT_TAB_0 = 8,
    DPP_STUMPRAM_PHYPORT_TAB_1 = 9,
    DPP_STUMPRAM_PHYPORT_TAB_2 = 10,
    DPP_STUMPRAM_FLOW_TCAM_0 = 11,
    DPP_STUMPRAM_FLOW_TCAM_1 = 12,
    DPP_STUMPRAM_RESULT_TABLE_0 = 13,
    DPP_STUMPRAM_RESULT_TABLE_1 = 14,
    DPP_STUMPRAM_PKTRX_PKT_CAPTURE = 15,
    DPP_STUMPRAM_PBU_IDMATH = 16,
    DPP_STUMPRAM_PBU_MACTH = 17,
    DPP_STUMPRAM_PBU_PKT_CAPTURE = 18,
    DPP_STUMPRAM_TDM_PORTMAP = 19,
    DPP_STUMPRAM_TDM_SAIDMAP = 20,
    DPP_STUMPRAM_SAFH = 21,
    DPP_STUMPRAM_ODMA_CAPTURE = 22,
    DPP_STUMPRAM_INT0 = 23,
    DPP_STUMPRAM_INT1 = 24,
    DPP_STUMPRAM_GROUPNUM = 25,
    DPP_STUMPRAM_TST_PKT = 26,
    DPP_STUMPRAM_TX_CFG = 27,
    DPP_STUMPRAM_CHK_CFG = 28,
    DPP_STUMPRAM_MA_CHK_CFG = 29,
    DPP_STUMPRAM_2544_CFG = 30,
    DPP_STUMPRAM_2544_PKT = 31,
    DPP_STUMPRAM_2544_CNT = 32,
    DPP_STUMPRAM_ETM_SHAP_BUCKET_MAP_TBL = 33,
    DPP_STUMPRAM_ETM_BKT_PARA_TBL = 34,
    DPP_STUMPRAM_ETM_FLOWQUE_PARA_TBL = 35,
    DPP_STUMPRAM_ETM_SE_PARA_TBL = 36,
    DPP_STUMPRAM_ETM_FLOWQUE_INS_TBL = 37,
    DPP_STUMPRAM_ETM_SE_INS_TBL = 38,
    DPP_STUMPRAM_ETM_EIR_CRS_FILTER_TBL = 39,
    DPP_STUMPRAM_DUP_TBL_RAM = 40,

    DPP_STUMPRAM_ID_MAX,
} DPP_STUMP_RAM_ID_E;

/** 控制打桩开启的模块唯一标识 */
typedef enum dpp_stump_module_id_e
{
    DPP_STUMPMODU_ALL         = 0,
    DPP_STUMPMODU_DDR         = 1,
    DPP_STUMPMODU_STAT        = 2,
    DPP_STUMPMODU_PKTRX       = 3,
    DPP_STUMPMODU_PBU         = 4,
    DPP_STUMPMODU_ODMA        = 5,
    DPP_STUMPMODU_PPU         = 6,
    DPP_STUMPMODU_OAM         = 7,
    DPP_STUMPMODU_TM          = 8,
    DPP_STUMPMODU_SE          = 9,
    DPP_STUMPMODU_SMMU0       = 10,
    DPP_STUMPMODU_eTcam       = 11,
    DPP_STUMPMODU_ID_MAX,
} DPP_STUMP_MODULE_ID_E;

/** 打桩RAM操作类型 */
typedef enum dpp_stump_ram_type_e
{
    DPP_STUMP_RAM_T_DIR   = 0,  /**<  @brief 通过直接寄存器间接访问的RAM */
    DPP_STUMP_RAM_T_IND   = 1,  /**<  @brief 通过间接寄存器间接访问的RAM */
    DPP_STUMP_RAM_T_INVALID,
} DPP_STUMP_RAM_TYPE_E;

/** 各模块打桩寄存器管理数据结构 */
typedef struct dpp_stump_module_reginfo_t
{
    ZXIC_UINT32 modu_id;
    ZXIC_UINT32 start_regno;
    ZXIC_UINT32 end_regno;
    ZXIC_UINT32 is_enable;
} DPP_STUMP_MODULE_REGINFO_T;

typedef struct dpp_stump_reg_rbkey_t
{
    ZXIC_UINT32 addr;
} DPP_STUMP_REG_RBKEY_T;

/** 多元直接寄存器软件缓存数据结构 */
typedef struct dpp_stump_reg_rbnode_t
{
    DPP_STUMP_REG_RBKEY_T reg_key;
    ZXIC_UINT32 m_offset;
    ZXIC_UINT32 n_offset;
    ZXIC_UINT32 reg_no;
    ZXIC_UINT32 reg_data[0];
} DPP_STUMP_REG_RBNODE_T;

typedef DPP_STATUS (*DPP_STUMP_RAMINIT)(ZXIC_UINT32 dev_id, ZXIC_UINT32 ram_id);

/** 通过多个直接寄存器间接访问的RAM表属性 */
typedef struct dpp_stump_ramattr_const_t
{
    ZXIC_UINT32 wr_type;            /**<  @brief RAM读写访问类型，取值详见DPP_STUMP_RAM_TYPE_E */
    ZXIC_UINT32 depth;              /**<  @brief RAM的深度，即最大条目数 */
    ZXIC_UINT32 width;              /**<  @brief RAM单个条目的宽度，以字节为单位，非字节对齐的ram数据高位填0 */
    ZXIC_UINT32 cmd_regno;          /**<  @brief 间接读写cmd寄存器的reg_no */
    ZXIC_UINT32 wt_done_regno;      /**<  @brief 间接写完成状态寄存器的reg_no, 若无则填DPP_STUMP_REG_NO_INVALID, 若与读完成复用则填相同值 */
    ZXIC_UINT32 rd_done_regno;      /**<  @brief 间接读完成状态寄存器的reg_no, 若无则填DPP_STUMP_REG_NO_INVALID, 若与写完成复用则填相同值 */
    ZXIC_UINT32 trig_regno;         /**<  @brief 间接读写触发寄存器的reg_no */
    ZXIC_UINT32 wt_reg_num;         /**<  @brief 间接写数据寄存器的个数 */
    ZXIC_UINT32 wt_regno_data;      /**<  @brief 间接写数据寄存器（可能多个）的reg_no, 从低32bit到高32bit依次排序 */
    ZXIC_UINT32 rd_reg_num;         /**<  @brief 间接读数据寄存器的个数 */
    ZXIC_UINT32 rd_regno_data;      /**<  @brief 间接读数据寄存器（可能多个）的reg_no, 从低32bit到高32bit依次排序 */
    ZXIC_UINT8   wr_bitpos;          /**<  @brief w/r标志在cmd寄存器的bit位置 */
    ZXIC_UINT8   wt_done_bitpos;     /**<  @brief 写完成标志在寄存器的bit位置 */
    ZXIC_UINT8   wt_done_sel;        /**<  @brief 表示rdy/done标志 =0表示0是空闲， =1表示1是空闲 */
    ZXIC_UINT8   rd_done_bitpos;     /**<  @brief 读完成标志在寄存器的bit位置 */
    ZXIC_UINT8   rd_done_sel;        /**<  @brief 表示rdy/done标志 =0表示0是空闲， =1表示1是空闲 */
    ZXIC_UINT8   addr_bitpos;        /**<  @brief addr在cmd寄存器中的最低位起始bit位置 */
    ZXIC_UINT8   addr_bitsize;       /**<  @brief addr的位宽, 以bit为单位 */
    ZXIC_UINT8   wr_bit_sel;         /**<  @brief w/r标志含义选择: 0-表示w/r标志为0是写操作，1- 表示w/r标志为0是读操作 */
    ZXIC_UINT8   memid_bitpos;       /**<  @brief memid的最低位起始bit位置，同一个CMD寄存器操作多个不同RAM时使用 */
    ZXIC_UINT8   memid_bitsize;      /**<  @brief memid的位宽，以比特为单位 */
    ZXIC_UINT32 mem_id;              /**<  @brief RAM对应的memid的值 */
} DPP_STUMP_RAMATTR_CONTST_T;

typedef struct dpp_dir_ram_ctrl_rbkey_t
{
    ZXIC_UINT32 mem_id;             /**<  @brief 用于同一个cmd寄存器操作多个RAM的场景，若无则填0 */
    ZXIC_UINT32 reg_no;
} DPP_DIR_RAM_CTRL_RBKEY_T;

/** RAM打桩使能控制缓存数据结构 */
typedef struct dpp_dir_ram_ctrl_rbnode_t
{
    DPP_DIR_RAM_CTRL_RBKEY_T dir_ram_key;
    ZXIC_UINT32                   ram_id;        /**<  @brief 打桩RAM表唯一索引，取值详见DPP_STUMP_RAM_ID_E */
} DPP_DIR_RAM_CTRL_RBNODE_T;


typedef struct dpp_ram_data_rbkey_t
{
    ZXIC_UINT32 addr;
} DPP_RAM_DATA_RBKEY_T;

typedef struct dpp_ram_data_rbnode_t
{
    DPP_RAM_DATA_RBKEY_T data_key;
    ZXIC_UINT8                 data[0];
} DPP_RAM_DATA_RBNODE_T;

typedef struct dpp_stump_ram_t
{
    ZXIC_UINT32                id;       /**<  @brief 打桩RAM表唯一索引，取值详见DPP_STUMP_RAM_ID_E */
    DPP_STUMP_RAMATTR_CONTST_T  *attr_const;
    ZXIC_RB_CFG            data_rb;//用红黑树的方式存储ram_table的多个数据
} DPP_STUMP_RAM_T;

/** RAM读写触发寄存器与CMD寄存器绑定关系结构 */
typedef struct dpp_trig_cmd_node_t
{
    ZXIC_UINT32 trig_regno;
    ZXIC_UINT32 cmd_regno;
    ZXIC_UINT32 memid_bitpos;
    ZXIC_UINT32 memid_bitsize;
    ZXIC_UINT32 wr_bitpos;
    ZXIC_UINT32 wr_bit_sel;
} DPP_TRIG_CMD_NODE_T;

/** SDK打桩功能管理结构 */
typedef struct dpp_stump_ctrl_t
{
    ZXIC_UINT32 is_init;
    ZXIC_UINT32 is_enable;
    ZXIC_RB_CFG reg_rb;                          /**<  @brief 多元直接寄存器缓存信息 */
    ZXIC_RB_CFG dir_ram_ctrl_rb;                 /**<  @brief 通过多个直接寄存器间接访问的RAM表读写控制信息 */
    ZXIC_RB_CFG tm_reg_rb;                       /**<  @brief tm ram信息*/
    ZXIC_RB_CFG ppu_sdt_rb;                      /**<  @brief sdt ram信息 */
    ZXIC_RB_CFG se_cpyinfo_0_rb;                 /**<  @brief se smmu1 cpy info 0 ram信息 */
    ZXIC_RB_CFG se_cpyinfo_1_rb;                 /**<  @brief se smmu1 cpy info 1 ram信息 */
    ZXIC_RB_CFG se_ddr_0_rb;                     /**<  @brief se smmu1 ddr非直接ram信息 */
    ZXIC_RB_CFG se_ddr_1_rb;                     /**<  @brief se smmu1 ddr直接ram信息 */
    ZXIC_RB_CFG se_alg_rb;                       /**<  @brief se alg ram信息 */
    ZXIC_RB_CFG se_car0_rb;                      /**<  @brief se CAR0 ram信息 */
    DPP_STUMP_RAM_T *ram_tbls;                  /**<  @brief ram表信息 */
    DPP_STUMP_MODULE_REGINFO_T *modu_reginfo;   /**<  @brief 各模块寄存器使能打桩记录信息 */
    D_HEAD                     trig_cmd_list;   /**<  @brief trig_regno与cmd_reg绑定关系链表 */
} DPP_STUMP_CTRL_T;


DPP_STATUS dpp_stump_ram_tx_rmon_init(ZXIC_UINT32 dev_id, ZXIC_UINT32 ram_id);
DPP_STATUS dpp_stump_ram_rx_rmon_init(ZXIC_UINT32 dev_id, ZXIC_UINT32 ram_id);
DPP_STATUS dpp_stump_ram_flexe_oh_replace_init(ZXIC_UINT32 dev_id, ZXIC_UINT32 ram_id);
DPP_STATUS dpp_stump_ram_flexe_oh_debug_capture_init(ZXIC_UINT32 dev_id, ZXIC_UINT32 ram_id);
DPP_STATUS dpp_stump_ram_flexe_oam_init(ZXIC_UINT32 dev_id, ZXIC_UINT32 ram_id);
DPP_STATUS dpp_stump_ram_stat_sdt_init(ZXIC_UINT32 dev_id, ZXIC_UINT32 ram_id);

DPP_STATUS dpp_stump_ctrl_init(ZXIC_UINT32 dev_id, ZXIC_UINT32 glb_enable);
DPP_STATUS dpp_stump_ramattr_init(ZXIC_UINT32 dev_id, ZXIC_UINT32 ram_id);
DPP_STATUS dpp_stump_glben_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 flag);
DPP_STATUS dpp_stump_glben_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 *p_flag);
DPP_STATUS dpp_stump_module_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id, ZXIC_UINT32 enable);
DPP_STATUS dpp_stump_module_en_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 module_id, ZXIC_UINT32 *p_enable);
/***********************************************************/
/** 判断此寄存器是否使能了打桩功能，若未开启则跳过打桩流程，正常访问硬件
* @param   dev_id   设备号
* @param   reg_no   寄存器编号, 取值详见DPP_REG_INFO_E
*
* @return
* @remark  无
* @see
* @author  wcl      @date  2018/11/02
************************************************************/
ZXIC_UINT32 dpp_stump_reg_en_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no);

/***********************************************************/
/** 打桩寄存器写接口，包含通过寄存器触发的RAM的读写操作
* @param   dev_id     设备号
* @param   reg_no     寄存器编号, 取值详见DPP_REG_INFO_E
* @param   m_offset   二元寄存器的m偏移
* @param   n_offset   一元寄存器或二元寄存器的n偏移
* @param   p_data     数据指针
*
* @return
* @remark  无
* @see
* @author  wcl      @date  2018/11/02
************************************************************/
DPP_STATUS dpp_stump_reg_write(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no, ZXIC_UINT32 m_offset, ZXIC_UINT32 n_offset, ZXIC_VOID *p_data);

/***********************************************************/
/** 打桩寄存器读接口
* @param   dev_id     设备号
* @param   reg_no     寄存器编号, 取值详见DPP_REG_INFO_E
* @param   m_offset   二元寄存器的m偏移
* @param   n_offset   一元寄存器或二元寄存器的n偏移
* @param   p_data     数据指针
*
* @return
* @remark  无
* @see
* @author  wcl      @date  2018/11/02
************************************************************/
DPP_STATUS dpp_stump_reg_read(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no, ZXIC_UINT32 m_offset, ZXIC_UINT32 n_offset, ZXIC_VOID *p_data);

DPP_STATUS dpp_stump_reg_rb_debug_rd(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 addr,
                                     ZXIC_UINT32 len,
                                     ZXIC_UINT32 *p_reg_data);
DPP_STATUS dpp_stump_reg_rb_debug_wr(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 addr,
                                     ZXIC_UINT32 len,
                                     ZXIC_UINT32 *p_reg_data);
DPP_STATUS dpp_stump_reg_rb_debug_tm_rd(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 addr,
                                     ZXIC_UINT32 len,
                                     ZXIC_UINT32 *p_reg_data);
DPP_STATUS dpp_stump_reg_rb_debug_tm_wr(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 addr,
                                     ZXIC_UINT32 len,
                                     ZXIC_UINT32 *p_reg_data);

DPP_STATUS dpp_tm_stump_process(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 size, ZXIC_UINT32* p_data);
DPP_STATUS dpp_stump_debug_en_set(ZXIC_UINT32 en);

DPP_STATUS dpp_stump_reg_rb_debug_dup_wr(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 addr,
                                     ZXIC_UINT32 len,
                                     ZXIC_UINT32 *p_reg_data);

DPP_STATUS dpp_stump_reg_rb_debug_dup_rd(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 addr,
                                     ZXIC_UINT32 len,
                                     ZXIC_UINT32 *p_reg_data);

DPP_STATUS dpp_stump_sdt_process(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no, ZXIC_UINT32 m_offset, ZXIC_UINT32 n_offset, ZXIC_UINT32* p_data);
DPP_STATUS dpp_stump_reg_rb_debug_sdt_wr(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 addr,
                                     ZXIC_UINT32 len,
                                     ZXIC_UINT32 *p_reg_data);
DPP_STATUS dpp_stump_reg_rb_debug_sdt_rd(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 addr,
                                     ZXIC_UINT32 len,
                                     ZXIC_UINT32 *p_reg_data);
DPP_STATUS dpp_stump_reg_rb_debug_cpyinfo_0_wr(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 addr,
                                               ZXIC_UINT32 len,
                                               ZXIC_UINT32 *p_reg_data);


DPP_STATUS dpp_stump_reg_rb_debug_cpyinfo_0_rd(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 addr,
                                               ZXIC_UINT32 len,
                                               ZXIC_UINT32 *p_reg_data);

DPP_STATUS dpp_stump_reg_rb_debug_cpyinfo_1_wr(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 addr,
                                               ZXIC_UINT32 len,
                                               ZXIC_UINT32 *p_reg_data);

DPP_STATUS dpp_stump_reg_rb_debug_cpyinfo_1_rd(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 addr,
                                               ZXIC_UINT32 len,
                                               ZXIC_UINT32 *p_reg_data);

DPP_STATUS dpp_stump_reg_rb_debug_ddr_0_wr(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 addr,
                                               ZXIC_UINT32 len,
                                               ZXIC_UINT32 *p_reg_data);

DPP_STATUS dpp_stump_reg_rb_debug_ddr_0_rd(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 addr,
                                               ZXIC_UINT32 len,
                                               ZXIC_UINT32 *p_reg_data);

DPP_STATUS dpp_stump_reg_rb_debug_ddr_1_wr(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 addr,
                                               ZXIC_UINT32 len,
                                               ZXIC_UINT32 *p_reg_data);

DPP_STATUS dpp_stump_reg_rb_debug_ddr_1_rd(ZXIC_UINT32 dev_id,
                                               ZXIC_UINT32 addr,
                                               ZXIC_UINT32 len,
                                               ZXIC_UINT32 *p_reg_data);



DPP_STATUS dpp_stump_smmu1_process(ZXIC_UINT32 dev_id, ZXIC_UINT32 reg_no, ZXIC_UINT32 m_offset, ZXIC_UINT32 n_offset, ZXIC_UINT32* p_data);

DPP_STATUS dpp_stump_alg_process(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 size, ZXIC_UINT32* p_data);

DPP_STATUS dpp_stump_car_init(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_stump_car0_process(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 size, ZXIC_UINT32* p_data);


DPP_STATUS dpp_stump_reg_rb_debug_alg_wr(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 addr,
                                     ZXIC_UINT32 len,
                                     ZXIC_UINT32 *p_reg_data);

DPP_STATUS dpp_stump_reg_rb_debug_alg_rd(ZXIC_UINT32 dev_id,
                                     ZXIC_UINT32 addr,
                                     ZXIC_UINT32 len,
                                     ZXIC_UINT32 *p_reg_data);

DPP_STATUS dpp_stump_reg_rb_debug_car0_wr(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 addr,
                                          ZXIC_UINT32 len,
                                          ZXIC_UINT32 *p_reg_data);

DPP_STATUS dpp_stump_reg_rb_debug_car0_rd(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 addr,
                                          ZXIC_UINT32 len,
                                          ZXIC_UINT32 *p_reg_data);


DPP_STATUS dpp_stump_ponmac_process(ZXIC_UINT32 dev_id, ZXIC_UINT32 addr, ZXIC_UINT32 size, ZXIC_UINT32* p_data);

#ifdef __cplusplus
}
#endif

#endif

