/**************************************************************
* Ȩ (C)2013-2015, ͨѶɷ޹˾
* ļ : dpp_diag.h
* ļʶ : 
* ժҪ : оƬòԺͷļ
* ˵ : 
* ǰ汾 : 
*      : wcl
*  : 2015/05/29
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
 
* ޸ļ¼1: 
* ޸:  
*   :  
*   :  
* ޸:  
***************************************************************/

#ifndef _DPP_DIAG_H_
#define _DPP_DIAG_H_

#define DPP_DEV_PPU_CLS_TEST_NUM   (3)
#define NO_ALARM_FLAG    (0)
#define ALARM_FLAG       (1)
#define MAX_ALARM_NUM    (20)
#define DAY_TIME         (24*60*60)
#define MAX_REG_BIT_NUM  (32)
#define RAM_ADDR         (0xFFFFFFFF)
//#define DPP_DEV_MAX      (4)
#define DPP_GET_RAND_COUNT  (1000)


typedef enum diag_dpp_se_check_ram_type_e
{
    RAM_TYPE_DDR     = 0,
    RAM_TYPE_ERAM    = 1
} DPP_DIAG_SE_CHECK_RAM_TYPE_E;

typedef struct diag_dpp_ppu_dup_tbl_t
{
    ZXIC_UINT32 item_vld;
    ZXIC_UINT32 flownum_vld;
    ZXIC_UINT32 start_pc;
    ZXIC_UINT32 flow_num;
}DPP_DIAG_PPU_DUP_TBL_T;

typedef struct dpp_oam_int0_ram_t
{
    ZXIC_UINT32 int0;
}DPP_OAM_INT0_RAM_T;


typedef struct dpp_keysig_mgr_t
{
    ZXIC_UINT32 is_init;
    D_HEAD head;

} DPP_KEYSIG_MGR_T;

typedef struct dpp_keysig_buf_t
{
    ZXIC_UINT32 current_time;
} DPP_KEYSIG_BHF_T;


typedef struct dpp_keysig_info_t
{
    ZXIC_UINT32 keysig_id;        /* ؼźű */
    ZXIC_UINT32 act_id;           /* 澯ִж*/
    ZXIC_UINT32 keysig_reg_addr;  /* ؼźڼĴĵַ */
    ZXIC_UINT32 keysig_reg_val;   /* ؼźڼĴֵ */
} DPP_KEYSIG_INFO_T;



/***********************************************************/
/** LIF0ӿ״̬
* @param   devi_id   оƬID
* @param   intf_id   ӿں
*
* @return
* @remark  
* @see
* @author  pw      @date  2016/05/05
************************************************************/
DPP_STATUS dpp_lif0_link_status_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 intf_id);

/***********************************************************/
/** LIF0 P2P ģʽӿLINK״̬
* @param   devi_id  оƬID
* @param   port_id   ˿ں(0-31)
*
* @return
* @remark  Ŀǰֻ֧P2P ģʽLINK״̬
* @see
* @author  baibing      @date  2020/08/05
************************************************************/
DPP_STATUS dpp_lif0_ponmac_link_status_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 port_id);


/***********************************************************/
/** LIF (PUB) ģд
* @param    dev_id   оƬID
* @param    mode     ģʽ  
* @param    data     д
*
* @return
* @remark  modeΪ
           mode: 0 
           mode: 1 ûdata
* @see
* @author  baibing      @date  2020/07/07
************************************************************/
DPP_STATUS dpp_lif_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

/***********************************************************/
/** serdes  pll ready״̬
* @param   dev_id     豸id
* @param   serdes_id  οMODULE_SERDES_ID_E
*
* @return  DPP_OK-ɹDPP_OK-ʧ
* @remark  
* @see
* @author  hxh      @date  2018/02/24
************************************************************/
DPP_STATUS diag_dpp_serdes_pll_sta_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 serdes_id);

/***********************************************************/
/** serdes  phyready״̬
* @param   dev_id     豸id
* @param   serdes_id  οMODULE_SERDES_ID_E
*
* @return  DPP_OK-ɹDPP_OK-ʧ
* @remark  
* @see
* @author   hxh      @date  2018/02/24
************************************************************/
DPP_STATUS diag_dpp_serdes_phyready_sta_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 serdes_id);

/***********************************************************/
/** seetcam ramȫַ
* @param   dev_id
* @param   mode       ģʽ 0:ģʽ1:ûdataģʽ
* @param   data       ûdata, modeΪ0,òЧ
* @return
* @remark  
* @see
* @author  yxh      @date  2018/02/23
************************************************************/
DPP_STATUS diag_dpp_se_etcam_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

/***********************************************************/
/** 
* @param   dev_id
* @param   mode       ģʽ 0:ģʽ1:ûdataģʽ
* @param   data       ûdata, modeΪ0,òЧ
*
* @return
* @remark  
* @see
* @author  YXH      @date  2020/07/06
************************************************************/
DPP_STATUS diag_dpp_se_eram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

/***********************************************************/
/** PPU鲥Ʊramд
* @param   dev_id
* @param   start_addr ʼַunit:2k*256bit
* @param   end_addr   ַunit:2k*256bit
* @param   mode       ģʽ 0:ģʽ1:ûdataģʽ
* @param   data       ûdata, modeΪ0,òЧ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ghm      @date  2020/07/06
************************************************************/
DPP_STATUS diag_dpp_se_ddr_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 start_addr, ZXIC_UINT32 end_addr, ZXIC_UINT32 mode, ZXIC_UINT32 data);

/***********************************************************/
/** tm crc
* @param   dev_id   
* @param   flow_num    ֵ֧У8ı
* @param   shape_cir   
* @param   shape_en    Ƿʹ
* @param   pkt_mode    0~16
*
* @return  
* @remark  
* @see     
* @author  XXX      @date  2019/03/12
************************************************************/
DPP_STATUS diag_dpp_tmcrc_dect_start(ZXIC_UINT32 dev_id, ZXIC_UINT32 flow_num, ZXIC_UINT32 shape_cir, ZXIC_UINT32 shape_en,ZXIC_UINT32 pkt_mode);

/***********************************************************/
/** TM DDR ʼģʽ
* @param   dev_id   
* @param   ddr_mode    0:4ddr  1:8ddr 32bank
*
* @return  
* @remark  
* @see     
* @author  XXX      @date  2019/01/30
************************************************************/
DPP_STATUS diag_dpp_tmcrc_ddr_mode_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 ddr_mode);

/***********************************************************/
/** ȡCRC
* @param   dev_id   
* @param   check_times   crc֮ļʱ1sΪλ
* @param   check_times   ѭ
*
* @return  
* @remark  
* @see     
* @author  XXX      @date  2019/01/28
************************************************************/
DPP_STATUS diag_dpp_tmcrc_err_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 sleep_time, ZXIC_UINT32 check_times, ZXIC_UINT32* crc_error_num);

/***********************************************************/
/** ֹͣtm crc
* @param   dev_id   
*
* @return  
* @remark  
* @see     
* @author  XXX      @date  2019/01/28
************************************************************/
DPP_STATUS diag_dpp_tmcrc_dect_stop(ZXIC_UINT32 dev_id);

DPP_STATUS diag_dpp_etcam_self_check_test(ZXIC_UINT32 dev_id);

DPP_STATUS diag_dpp_etcam_self_check_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num);

DPP_STATUS diag_dpp_srhin_self_check_test(ZXIC_UINT32 dev_id);

DPP_STATUS diag_dpp_srhin_self_check_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num);

DPP_STATUS diag_dpp_srhin_complete_moving_inversions_test(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num);

DPP_STATUS diag_dpp_srhin_complete_shift_moving_inversions_test(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num);

DPP_STATUS diag_dpp_srhin_half_moving_inversions_test(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num);

DPP_STATUS diag_dpp_srhin_test_pkt_send(ZXIC_UINT32 dev_id, ZXIC_UINT32 wr_mcode_pc, ZXIC_UINT32 rd_mcode_pc, ZXIC_UINT32 oam_flow_num);

DPP_STATUS diag_dpp_srhex_self_check_test(ZXIC_UINT32 dev_id);

DPP_STATUS diag_dpp_srhex_self_check_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num, ZXIC_UINT32 ddr_group);

DPP_STATUS diag_dpp_tmcrc_check_test(ZXIC_UINT32 dev_id, ZXIC_UINT32 ddr_no_temp, ZXIC_UINT32 slot_id);

DPP_STATUS diag_dpp_tm_crc_check_test_etm(ZXIC_UINT32 dev_id, ZXIC_UINT32 slot_id);

DPP_STATUS diag_dpp_tm_crc_check_test(ZXIC_UINT32 dev_id, ZXIC_UINT32 slot_id);

DPP_STATUS diag_dpp_160g_check_test(ZXIC_UINT32 dev_id, ZXIC_UINT32 slot_id);

DPP_STATUS diag_dpp_160g_check_test_subddr(ZXIC_UINT32 dev_id, ZXIC_UINT32 slot_id, ZXIC_UINT32 ddr_group1, ZXIC_UINT32 ddr_group2);

DPP_STATUS dpp_pktrx_phyport_table0_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

DPP_STATUS dpp_pktrx_phyport_table1_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

DPP_STATUS dpp_pktrx_phyport_table2_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

DPP_STATUS dpp_memtest86_test(ZXIC_UINT32 dev_id, ZXIC_UINT32 eram_or_ddr);

DPP_STATUS dpp_ddr_memtest86_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_ddr_memtest86_pkt_send(ZXIC_UINT32 dev_id, ZXIC_UINT32 wr_mcode_pc, ZXIC_UINT32 rd_mcode_pc);

DPP_STATUS dpp_ddr_memtest86_walking_one_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_ddr_memtest86_own_address_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_ddr_memtest86_bit_fade_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_ddr_memtest86_half_moving_inversions_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_ddr_memtest86_modulo_x_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_ddr_memtest86_complete_moving_inversions_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_ddr_memtest86_complete_shift_moving_inversions_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_ddr_memtest86_ones_and_zeros_moving_inversions_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_ddr_memtest86_random_data_moving_inversions_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_ddr_memtest86_8_bit_walking_moving_inversions_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_memtest86_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 eram_or_ddr, ZXIC_UINT32 ddr_group, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_ddr_memtest86_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 ddr_group, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_ddr_memtest86_walking_one_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 ddr_group, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_ddr_memtest86_own_address_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 ddr_group, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_ddr_memtest86_bit_fade_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 ddr_group, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_ddr_memtest86_half_moving_inversions_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 ddr_group, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_ddr_memtest86_modulo_x_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 ddr_group, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_ddr_memtest86_complete_moving_inversions_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 ddr_group, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_ddr_memtest86_complete_shift_moving_inversions_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 ddr_group, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_ddr_memtest86_ones_and_zeros_moving_inversions_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 ddr_group, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_ddr_memtest86_8_bit_walking_moving_inversions_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 ddr_group, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_ddr_memtest86_random_data_moving_inversions_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 ddr_group, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_ddr_memtest86_pkt_send_sub(ZXIC_UINT32 dev_id,
                                          ZXIC_UINT32 wr_mcode_pc,
                                          ZXIC_UINT32 rd_mcode_pc,
                                          ZXIC_UINT32 ddr_group,
                                          ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_eram_memtest86_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_eram_memtest86_walking_one_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_eram_memtest86_own_address_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_eram_memtest86_bit_fade_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_eram_memtest86_half_moving_inversions_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_eram_memtest86_modulo_x_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_eram_memtest86_complete_moving_inversions_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_eram_memtest86_complete_shift_moving_inversions_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_eram_memtest86_ones_and_zeros_moving_inversions_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_eram_memtest86_8_bit_walking_moving_inversions_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_eram_memtest86_random_data_moving_inversions_test(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_eram_memtest86_pkt_send(ZXIC_UINT32 dev_id, ZXIC_UINT32 wr_mcode_pc, ZXIC_UINT32 rd_mcode_pc);

DPP_STATUS dpp_eram_memtest86_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_eram_memtest86_walking_one_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_eram_memtest86_own_address_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_eram_memtest86_bit_fade_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_eram_memtest86_half_moving_inversions_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_eram_memtest86_modulo_x_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_eram_memtest86_complete_moving_inversions_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_eram_memtest86_complete_shift_moving_inversions_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_eram_memtest86_ones_and_zeros_moving_inversions_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_eram_memtest86_8_bit_walking_moving_inversions_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_eram_memtest86_random_data_moving_inversions_test_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 oam_flow_num);

DPP_STATUS dpp_eram_memtest86_pkt_send_sub(ZXIC_UINT32 dev_id, ZXIC_UINT32 wr_mcode_pc, ZXIC_UINT32 rd_mcode_pc, ZXIC_UINT32 oam_flow_num);
#if 0
/***********************************************************/
/** ָDDR bankCPUȫַ
* @param   dev_id
* @param   mode       ģʽ 0:ģʽ1:ûdataģʽ
* @param   data       ûdata, modeΪ0,òЧ
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  ghm      @date  2020/07/06
************************************************************/
DPP_STATUS diag_dpp_se_ddr_check_by_bank(ZXIC_UINT32 dev_id,
                                         ZXIC_UINT32 start_bank_id,
                                         ZXIC_UINT32 end_bank_id,
                                         ZXIC_UINT32 mode,
                                         ZXIC_UINT32 data);
#endif
DPP_STATUS dpp_pktrx_tcam_xytcam_ram_check(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_pktrx_tcam_result_ram_check(ZXIC_UINT32 dev_id);

DPP_STATUS dpp_pbu_idma_th_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

DPP_STATUS dpp_pbu_mac_th_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

DPP_STATUS dpp_ppu_instr_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

DPP_STATUS dpp_ppu_dup_tbl_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

DPP_STATUS dpp_oam_int1_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

DPP_STATUS dpp_oam_tst_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

DPP_STATUS dpp_oam_2544_pkt_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

DPP_STATUS dpp_oam_tx_tbl_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

DPP_STATUS dpp_oam_check_tbl_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

DPP_STATUS dpp_oam_ma_tbl_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

DPP_STATUS dpp_oam_int0_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

/***********************************************************/
/** Shap_bucket_map_tblд
* @param    dev_id   оƬID
* @mode     mode     ģʽ  
* @param    data     д
*
* @return
* @remark  modeΪ
           mode: 0 
           mode: 1 ûdata
* @see
* @author  xuhb      @date  2020/07/07
************************************************************/
DPP_STATUS dpp_tm_shap_bucket_map_tbl_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

/***********************************************************/
/** bkt_para_tblд
* @param    dev_id   оƬID
* @mode     mode     ģʽ  
* @param    data     д
*
* @return
* @remark  modeΪ
           mode: 0 
           mode: 1 ûdata
* @see
* @author  xuhb      @date  2020/07/07
************************************************************/
DPP_STATUS dpp_tm_shap_bkt_para_tbl_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

/***********************************************************/
/** flowque_para_tblд
* @param    dev_id   оƬID
* @mode     mode     ģʽ  
* @param    data     д
*
* @return
* @remark  modeΪ
           mode: 0 
           mode: 1 ûdata
* @see
* @author  xuhb      @date  2020/07/07
************************************************************/
DPP_STATUS dpp_tm_crdt_flowque_para_tbl_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

/***********************************************************/
/** se_para_tblд
* @param    dev_id   оƬID
* @mode     mode     ģʽ  
* @param    data     д
*
* @return
* @remark  modeΪ
           mode: 0 
           mode: 1 ûdata
* @see
* @author  xuhb      @date  2020/07/07
************************************************************/
DPP_STATUS dpp_tm_crdt_se_para_tbl_ram_check(ZXIC_UINT32 dev_id, ZXIC_UINT32 mode, ZXIC_UINT32 data);

/***********************************************************/
/** ͷŲ
* @param   dev_id
* @param   p_keysig_mng
*
* @return
* @remark  
* @see
* @author  zhaisy            @date  2019/11/29
************************************************************/
DPP_STATUS dpp_chip_ksig_list_dest(D_NODE* node);

/***********************************************************/
/** °󶨹ؼźżĴĳbitĸ澯ִж 
* @param   keysig_id   ؼźű
* @param   bit_offset      bitƫ
* @param   bit_mask        bit 0/1
* @param   actiont         bitӦĶ
* @param   trig_condition     0--1        1--10 2--1ۼ10
*
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  zhaisyu      @date  2019/11/26
************************************************************/
DPP_STATUS dpp_chip_ksig_act_bind(ZXIC_UINT32 keysig_id, ZXIC_UINT32 bit_offset, ZXIC_UINT32 bit_mask, ZXIC_UINT32 action, ZXIC_UINT32 trig_condition);

/***********************************************************/
/** °󶨹ؼźŵ룬ҪĵļĴֱ˵
* @param   reg_addr   Եַ
* @param   reg_mask      ЩbitҪ
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  zhaisyu      @date  2019/11/26
************************************************************/
DPP_STATUS dpp_chip_ksig_reg_addr_mask_set(ZXIC_UINT32 reg_addr, ZXIC_UINT32 reg_mask);

/***********************************************************/
/** װʼact
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  zhaisyu      @date  2019/12/18
************************************************************/
DPP_STATUS dpp_chip_ksig_jig_init(ZXIC_VOID);

/***********************************************************/
/** ޸ӿ,漰 SA LIFģ
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  zhaisyu      @date  2020/05/14
************************************************************/
DPP_STATUS dpp_chip_ksig_repair_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 ksig_id, ZXIC_UINT32 keysig_reg_val);

/***********************************************************/
/** 澯 Ĵƻȡ
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  zhaisyu      @date  2020/05/14
************************************************************/
DPP_STATUS dpp_chip_ksig_name_get(ZXIC_UINT32 dev_id, ZXIC_UINT32 ksig_id, ZXIC_CHAR** keysig_reg_name);

/***********************************************************/
/** оƬؼźŸ澯ʹ
* @param   en_flag      ʹ 0-disable      1-enable
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  zhaisyu      @date  2020/03/25
************************************************************/
DPP_STATUS diag_dpp_chip_ksig_enable_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 en_flag);

/***********************************************************/
/** ĴksϢӡ
* @param   keysig_id   ؼźű
* @param   mask      ЩbitҪ
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  zhaisyu      @date  2019/11/26
************************************************************/
DPP_STATUS diag_dpp_chip_ksig_reg_info_prt(ZXIC_UINT32 keysig_id);

DPP_STATUS diag_dpp_chip_ksig_test(ZXIC_UINT32 dev_id);

/***********************************************************/
/** 160G 
* @param   dev_id   
* @param   type    0: serdes lp 1: pcs lp
*
* @return  
* @remark  
* @see     
* @author  XXX      @date  2020/09/04
************************************************************/
DPP_STATUS diag_dpp_160g_loop_type_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 type);

/***********************************************************/
/** 
* @param   dev_id   
* @param   slot_id   
*
* @return  
* @remark  
* @see     
* @author  XXX      @date  2020/08/29
************************************************************/
DPP_STATUS diag_dpp_160g_check_test_for_c620(ZXIC_UINT32 dev_id, ZXIC_UINT32 slot_id);

/***********************************************************/
/** оƬؼźŸ澯ʹܴӡ
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  zhaisyu      @date  2019/12/18
************************************************************/
DPP_STATUS diag_dpp_chip_ksig_enable_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** Ĵksģӡ
* @param   keysig_id   ؼźű
* @return  DPP_OK-ɹDPP_ERR-ʧ
* @remark  
* @see
* @author  zhaisyu      @date  2019/11/26
************************************************************/
DPP_STATUS diag_dpp_chip_ksig_module_prt(ZXIC_UINT32 keysig_id);


DPP_STATUS diag_dpp_ppu_cls_clk_en_prt(ZXIC_UINT32 dev_id);

#endif /* dpp_diag.h */



