/**************************************************************
* 版权所有 (C)2013-2015, 深圳市中兴通讯股份有限公司
* 文件名称 : dpp_trpg_diag.h
* 文件标识 : 
* 内容摘要 : 
* 其它说明 : 
* 当前版本 : 
* 作    者 : cjc
* 完成日期 : 2016/01/18
* DEPARTMENT: ASIC_FPGA_R&D_Dept 
* MANUAL_PERCENT: 100%   
* 修改记录1: 
* 修改日期:  
* 版 本 号:  
* 修 改 人:  
* 修改内容:  
***************************************************************/

#ifndef _DPP_TRPG_DIAG_H_
#define _DPP_TRPG_DIAG_H_

#include "dpp_trpg_api.h"
#include "dpp_trpg.h"
#include "zxic_common.h"
#include "dpp_type_api.h"
#include "dpp_trpg_reg.h"
#include "dpp_reg_info.h"
#include "dpp_reg_api.h"
#include "dpp_module.h"

#ifdef __cplusplus
extern "C" {
#endif

/***********************************************************/
/** TRPG 端口信息
* @param   dev_id        设备号
* @param   extlPort      外端口号
* @return
* @remark  无
* @see
* @author  sunlin      @date  2022/08/31
************************************************************/
ZXIC_VOID diag_dpp_trpg_port_info_show(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG 外端口 主备端口状态获取
* @param   dev_id        设备号
* @param   extlPort      外端口号
* @return
* @remark  无
* @see
* @author  sunlin      @date  2022/08/31
************************************************************/
DPP_STATUS diag_dpp_trpg_extlport_ms_status_prt(ZXIC_UINT32 dev_id, DPP_TRPG_EXTLPORT_NUM extlPort);

/***********************************************************/
/** TRPG TOD时间戳 获取时间戳更新中断
* @param   dev_id   设备号
* @return
* @remark  无
* @see
* @author  sunlin      @date  2022/08/31
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_glb_tod_update_int_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG TX 读取TOD时间戳进行打印
* @param   dev_id     设备号
* @return
* @remark  无
* @see
* @author  sunlin      @date  2022/08/31
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_glb_tod_all_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG 手敲产生时间戳更新中断
* @param   dev_id  设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_glb_tod_update_int_create(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG RX INT&EXT PORT PKT NUMBER PRINT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_pkt_num_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT PKT BYTE NUMBER PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_pkt_byte_num_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT PKT CNT CLR
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_pkt_cnt_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT PKT NUMBER PRINT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_pkt_num_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG tx INT&EXT PORT PKT BYTE NUMBER PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_pkt_byte_num_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT PKT CNT CLR
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_pkt_cnt_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT PKT CNT PRT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_port_pkt_cnt_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG INT&EXT PORT PKT TOTAL CNT PRT
* @param   dev_id  设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_port_pkt_total_cnt_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG EXTERNAL PORT MASTER SLAVE ENABLE PRINT
* @param   dev_id      设备号
* @param   extlPort    外端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_extlport_ms_en_prt(ZXIC_UINT32 dev_id, DPP_TRPG_EXTLPORT_NUM extlPort);

/***********************************************************/
/** TRPG EXTERNAL PORT MASTER SLAVE CONFIGURE PRINT
* @param   dev_id      设备号
* @param   extlPort    外端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_extlport_ms_config_prt(ZXIC_UINT32 dev_id, DPP_TRPG_EXTLPORT_NUM extlPort);

/***********************************************************/
/** TRPG INT&EXT PORT ENABLE PRINT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_port_packet_en_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG INT&EXT ALL PORT ENABLE SET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_all_port_packet_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNoS, ZXIC_UINT32 portNoE, BOOLEAN enable);

/***********************************************************/
/** TRPG INT&EXT PORT INNER LOOPBACK ENABLE PRINT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_port_inner_loopback_en_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG INT&EXT ALL PORT INNER LOOPBACK ENABLE SET
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_all_port_inner_loopback_en_set(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNoS, ZXIC_UINT32 portNoE, BOOLEAN enable);

/***********************************************************/
/** TRPG RX EXTERNAL PORT FC PAUSE THRESHOLD PRINT
* @param   dev_id         设备号 
* @param   extlPort       外端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_extlport_pause_threshold_prt(ZXIC_UINT32 dev_id, DPP_TRPG_EXTLPORT_NUM extlPort);

/***********************************************************/
/** TRPG RX INT&EXT PORT RAM ALMOST FULL LEVEL PRINT
* @param   dev_id   设备号 
* @param   portNo   端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_ram_almost_full_level_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INTERNAL PORT PFC ENABLE PRINT
* @param   dev_id      设备号 
* @param   intlPort    内端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_intlport_pfc_en_prt(ZXIC_UINT32 dev_id, DPP_TRPG_INTLPORT_NUM intlPort);

/***********************************************************/
/** TRPG RX INT&EXT PORT RAM TEST ENABLE PRINT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_ram_test_en_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT TOKEN BUCKET FC CLOCK FREQ PRINT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_token_bucket_fc_clk_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT TOKEN BUCKET FC ENABLE PRINT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_token_bucket_fc_en_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT TOKEN BUCKET FC ADD NUM PRINT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_token_bucket_fc_add_num_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT TOKEN BUCKET FC MAX NUM PRINT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_token_bucket_fc_max_num_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT TOKEN BUCKET FC CONFIG PRINT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_token_bucket_fc_config_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT STATUS PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_status_info_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT RX RAM HISTORY MAX DEPTH PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_ram_history_max_depth_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT RX RAM HISTORY MAX DEPTH CLEAR
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_ram_history_max_depth_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT RX PKT HISTORY MAX LENGTH PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_pkt_history_max_len_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT RX PKT HISTORY MAX LENGTH CLEAR
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_pkt_history_max_len_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT RX PKT HISTORY MIN LENGTH PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_pkt_history_min_len_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT RX PKT HISTORY MIN LENGTH CLEAR
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_pkt_history_min_len_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT DATA RAM PRT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @param   word_num    字号(需要 96行*每行2048bit/每次读32bit=6144次 可以将data_buffer全读出)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_data_ram_word_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 word_num);

/***********************************************************/
/** TRPG RX INT&EXT PORT DATA RAM PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_data_ram_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT DATA RAM ROW PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @param   rowNum      RAM行号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_data_ram_row_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 rowNum);

/***********************************************************/
/** TRPG RX INT&EXT PORT INFO RAM PRT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @param   word_num    字号(需要 96行*每行（136bit有效，拓展到256bit）,每次读32bit,读480次 可以将data_buffer全读出,(第4，第9.....字中，第一个字节有效)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_info_ram_word_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 word_num);

/***********************************************************/
/** TRPG RX INT&EXT PORT INFO RAM PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_info_ram_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG RX INT&EXT PORT INFO RAM PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @param   rowNum      RAM行号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port_info_ram_row_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 rowNum);

/***********************************************************/
/** TRPG TX INT&EXT PORT RAM ALMOST FULL LEVEL PRINT
* @param   dev_id   设备号 
* @param   portNo   端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_ram_almost_full_level_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT RAM TEST ENABLE PRINT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_ram_test_en_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT TOKEN BUCKET FC CLOCK FREQ PRINT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_token_bucket_fc_clk_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT TOKEN BUCKET FC ENABLE PRINT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_token_bucket_fc_en_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT TOKEN BUCKET FC ADD NUM PRINT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_token_bucket_fc_add_num_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT TOKEN BUCKET FC MAX NUM PRINT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @param   maxNum  端口令牌桶流控令牌桶的深度
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_token_bucket_fc_max_num_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT TOKEN BUCKET FC CONFIG PRINT
* @param   dev_id  设备号 
* @param   portNo  端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_token_bucket_fc_config_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT STATUS PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_status_info_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT TX RAM HISTORY MAX DEPTH PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_ram_history_max_depth_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT TX RAM HISTORY MAX DEPTH CLEAR
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_ram_history_max_depth_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT TX PKT HISTORY MAX LENGTH PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_pkt_history_max_len_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT TX PKT HISTORY MAX LENGTH CLEAR
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_pkt_history_max_len_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT TX PKT HISTORY MIN LENGTH PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_pkt_history_min_len_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT TX PKT HISTORY MIN LENGTH CLEAR
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_pkt_history_min_len_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG PORT STAT CNT CLEAR
* @param   dev_id        设备号
* @param   portNo        端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_port_stat_cnt_clr(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG ALL PORT STAT CNT CLEAR
* @param   dev_id        设备号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_all_port_stat_cnt_clr(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG TX INT&EXT PORT STATUS PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_port_status_info_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT DATA RAM PRT
* @param   dev_id      设备号 
* @param   portRamNo   端口RAM号
* @param   word_num    字号(需要 144行*每行(72bit有效，拓展到128bit)，每次读32bit，需要432次 可以将data_buffer全读出, （第2，第6.....字中，第一个字节有效)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_data_ram_word_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 word_num);

/***********************************************************/
/** TRPG TX INT&EXT PORT DATA RAM PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_data_ram_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT DATA RAM ROW PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @param   rowNum      ram行号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_data_ram_row_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 rowNum);

/***********************************************************/
/** TRPG TX INT&EXT PORT INFO RAM PRT
* @param   dev_id      设备号 
* @param   portRamNo   端口RAM号
* @param   word_num    字号(需要 144行*每行(72bit有效，拓展到128bit)，每次读32bit，需要432次 可以将data_buffer全读出, （第2，第6.....字中，第一个字节有效)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_info_ram_word_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 word_num);

/***********************************************************/
/** TRPG TX INT&EXT PORT INFO RAM PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_info_ram_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo);

/***********************************************************/
/** TRPG TX INT&EXT PORT INFO RAM PRINT
* @param   dev_id      设备号 
* @param   portNo      端口号
* @param   rowNum      RAM行号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port_info_ram_row_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 rowNum);

/***********************************************************/
/** TRPG TX ETM PORT RAM ALMOST FULL LEVEL PRINT
* @param   dev_id   设备号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_etm_port_ram_almost_full_level_prt(ZXIC_UINT32 dev_id);
/***********************************************************/
/** TRPG TX ETM PORT RAM TEST ENABLE PRINT
* @param   dev_id  设备号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_etm_port_ram_test_en_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG TX ETM PORT DATA RAM PRT
* @param   dev_id      设备号 
* @param   word_num    字号(需要 32行*每行2048bit/每次读32bit=2048次 可以将data_buffer全读出)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_etm_port_data_ram_word_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 word_num);

/***********************************************************/
/** TRPG TX ETM PORT DATA RAM PRINT
* @param   dev_id      设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_etm_port_data_ram_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG TX ETM PORT DATA RAM ROW PRINT
* @param   dev_id      设备号 
* @param   rowNum      RAM行号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_etm_port_data_ram_row_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 rowNum);

/***********************************************************/
/** TRPG TX ETM PORT INFO RAM PRT
* @param   dev_id      设备号 
* @param   word_num    字号(需要 32行*每行(72bit有效，拓展到128bit)，每次读32bit，读96次可以将data_buffer全读出, 第2，第6.....字中，第一个字节有效)
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_etm_port_info_ram_word_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 word_num);

/***********************************************************/
/** TRPG TX ETM PORT INFO RAM PRINT
* @param   dev_id      设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_etm_port_info_ram_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG TX ETM PORT INFO RAM PRINT
* @param   dev_id      设备号 
* @param   rowNum      行号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_etm_port_info_ram_row_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 rowNum);

/***********************************************************/
/** TRPG TX GLB TOD TIME UPDATE INTERRUPTION MASK PRINT
* @param   dev_id  设备号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_glb_tod_update_interrupt_mask_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG TX GLB TOD TIME RAM TEST ENABLE PRINT
* @param   dev_id  设备号
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_glb_tod_ram_test_en_prt(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG TX GLB TOD TIME PRINT
* @param   dev_id        设备号 
* @param   ioamFlowId    时间戳报文flow id
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_glb_tod_prt(ZXIC_UINT32 dev_id, ZXIC_UINT32 ioamFlowId);

/***********************************************************/
/** TRPG RX&TX PORT STATUS PRINT
* @param   dev_id        设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_tx_port(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG RX&TX EXTL PORT STATUS PRINT
* @param   dev_id        设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_tx_extlport(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG RX PORT STATUS PRINT
* @param   dev_id        设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_port(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG RX EXTL PORT STATUS PRINT
* @param   dev_id        设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_extlport(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG RX INTL PORT STATUS PRINT
* @param   dev_id        设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_rx_intlport(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG TX PORT STATUS PRINT
* @param   dev_id        设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_port(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG TX ETM PORT STATUS PRINT
* @param   dev_id        设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_etm_port(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG TX TOD STATUS PRINT
* @param   dev_id        设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg_tx_tod(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG REG CHECK
* @param   dev_id        设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_reg_check(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG STATUS PRINT
* @param   dev_id        设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS diag_dpp_trpg(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG HELP
* @param   dev_id        设备号 
* @return  
* @remark  无
* @see     
* @author  sunlin      @date  2022/08/29
************************************************************/
DPP_STATUS dpp_trpg_help(ZXIC_UINT32 dev_id);

/***********************************************************/
/** TRPG PPS PTR
* @param   dev_id        设备号 
* @return  
* @remark  无
* @see     
* @author  wangfei      @date  2024/04/14
************************************************************/
DPP_STATUS diag_dpp_trpg_pps_ptr(ZXIC_UINT32 dev_id, ZXIC_UINT32 portNo, ZXIC_UINT32 timeMax);
#ifdef __cplusplus
}
#endif

#endif